VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "ClsMainMenu"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit
'--------------------------------------
'Autor: Leandro Ascierto
'Web: www.leandroascierto.com.ar
'Date: 02/07/2011
'Projet Name: RssReader
'---------------------------------------
Private Const WM_MENUSELECT         As Long = &H11F
Private Const WM_ENTERIDLE          As Long = &H121

Private Const GA_PARENT             As Long = 1
Private Const GA_ROOT               As Long = 2
Private Const GA_ROOTOWNER          As Long = 3

Private WithEvents cImgMenu         As clsMenuImage
Attribute cImgMenu.VB_VarHelpID = -1
Private WithEvents cTimer           As ClsTimer
Attribute cTimer.VB_VarHelpID = -1
Private MainMenu                    As Long
Private cFeed                       As Collection
Private cSubMenu                    As ClsSubMenu
Private m_Index                     As Long
Private m_LButonMouseStatePress     As Boolean
Private m_MnuPos                    As Long
Private m_HiLitePos                 As Long

Private Sub cImgMenu_MenuMessages(ByVal hwnd As Long, ByVal uMsg As Long, ByVal wParam As Long, ByVal lParam As Long)

    On Error Resume Next
    
    Dim hSubMenu        As Long
    Dim hNewSubMenu     As Long
    Dim i               As Long
    Dim Index           As Long
    Dim MII             As MENUITEMINFO
    Dim PT              As POINTAPI
    Dim MnuPos          As Long
    Dim hWinMenu        As Long
    Dim tRec            As RECT
    Dim sHTML           As String
    Dim RecForm         As RECT
    Dim lTop            As Long
    Dim lLeft           As Long
    
    If uMsg = WM_MENUSELECT Then
 
        GetCursorPos PT
        If GetAncestor(WindowFromPoint(PT.x, PT.y), GA_ROOT) = FrmMenuRss.hwnd Then
            MII.cbSize = Len(MII)
            MII.fMask = MIIM_STATE
            MII.fState = MF_HILITE
            SetMenuItemInfo cFeed(m_Index).hMenu, m_MnuPos, True, MII
            m_HiLitePos = m_MnuPos
            Exit Sub
        Else
            If m_HiLitePos > -1 And LoWord(wParam) <> m_HiLitePos Then
                MII.cbSize = Len(MII)
                MII.fMask = MIIM_STATE
                MII.fState = 0
                SetMenuItemInfo cFeed(m_Index).hMenu, m_HiLitePos, True, MII
                HiliteMenuItem FrmMenuRss.hwnd, cFeed(m_Index).hMenu, m_HiLitePos, MF_BYPOSITION Or MF_UNHILITE
                m_HiLitePos = -1
            End If
        End If
   
        m_Index = -1
        For i = 1 To cFeed.Count
            If lParam = cFeed(i).hMenu Then
                m_Index = i
                Exit For
            End If
        Next
    
    End If
    
    If uMsg = WM_ENTERIDLE Then
            If m_Index = -1 Then
                m_MnuPos = -1
                FrmMenuRss.Visible = False
                Exit Sub
            End If
            
            hSubMenu = cFeed(m_Index).hMenu
            GetCursorPos PT
            MnuPos = MenuItemFromPoint(0, hSubMenu, PT.x, PT.y)

            If MnuPos > cFeed(m_Index).ItemCount Then
                m_MnuPos = -1
                FrmMenuRss.Visible = False
                Exit Sub
            End If
            
            If MnuPos <> -1 Then
                If GetKeyState(1) < 0 Then
                    m_LButonMouseStatePress = True
                Else
                    If m_LButonMouseStatePress Then
                        If m_MnuPos > -1 And m_MnuPos <= cFeed(m_Index).ItemCount Then
                            EndMenu
                            FrmMenuRss.Visible = False
                            ShellExecute FrmMenuRss.hwnd, vbNullString, cFeed(m_Index).Link(m_MnuPos), vbNullString, "C:\", vbNormal
                        End If
                        m_LButonMouseStatePress = False
                        
                    End If
                End If

                If m_MnuPos <> MnuPos Then
                    
                    m_MnuPos = MnuPos
                    FrmMenuRss.Visible = False
                    GetMenuItemRect 0, hSubMenu, m_MnuPos, tRec
                    sHTML = "<body style='font-size: small; font-family: Arial;'><p style='font-size: x-small'><a href='" & cFeed(m_Index).Link(m_MnuPos) & "'><strong>" & cFeed(m_Index).Title(m_MnuPos) & "</strong></a><br />"
                    If Len(cFeed(m_Index).sDate(m_MnuPos)) Then
                        sHTML = sHTML & "<span style='color: gray; font-size: xx-small'>" & cFeed(m_Index).sDate(m_MnuPos) & "</span><br /><br />"
                    End If
                    sHTML = sHTML & "</p>" & cFeed(m_Index).Descriptions(m_MnuPos) & "</body>"
                    
                    FrmMenuRss.SetValue sHTML
                    
                    If FrmMenuRss.Height > Screen.Height Then
                        FrmMenuRss.Width = FrmMenuRss.Width + FrmMenuRss.Height - Screen.Height
                        FrmMenuRss.Height = Screen.Height
                    End If
                   
                    If PtInRect(tRec, PT.x, PT.y) = 0 Then
                        Dim MenuHeight  As Long
                        MenuHeight = tRec.Bottom - tRec.Top
                        tRec.Top = PT.y
                        tRec.Bottom = tRec.Top + MenuHeight
                    End If

                    lTop = tRec.Top + ((tRec.Bottom - tRec.Top) / 2) - (FrmMenuRss.ScaleHeight / 2)
                    If lTop < 0 Then lTop = 0
                    If lTop + FrmMenuRss.ScaleHeight > (Screen.Height / Screen.TwipsPerPixelY) Then lTop = (Screen.Height / Screen.TwipsPerPixelY) - FrmMenuRss.ScaleHeight
                    If tRec.Right + FrmMenuRss.ScaleWidth < (Screen.Width / Screen.TwipsPerPixelX) Then
                        lLeft = tRec.Right
                    Else
                        lLeft = tRec.Left - FrmMenuRss.ScaleWidth
                    End If
                    
                    SetWindowPos FrmMenuRss.hwnd, HWND_TOPMOST, lLeft, lTop, 0, 0, SWP_NOACTIVATE Or SWP_SHOWWINDOW Or SWP_NOSIZE
                    FrmMenuRss.SetMenuPos tRec.Left, tRec.Top + ((tRec.Bottom - tRec.Top) / 2)
                    
                End If
            Else
                m_MnuPos = -1
            End If

    End If
    
End Sub

Public Function GetRssReadCount() As Long
    Dim i As Long
    For i = 1 To cFeed.Count
        If cFeed(i).ItemCount > -1 Then
            GetRssReadCount = GetRssReadCount + 1
        End If
    Next
End Function

Public Function PopUpMenu(hwnd As Long, Optional ByVal x As Long, Optional ByVal y As Long) As Long
    On Error Resume Next

    Dim PT              As POINTAPI
    Dim i               As Long
    Dim lRet            As Long
    Dim j               As Long


    MainMenu = CreatePopupMenu()

    If Not cImgMenu.IsWindowVistaOrLater Then
        cImgMenu.RemoveMenuCheckApi MainMenu
    End If

    For i = 1 To cFeed.Count
        If cFeed(i).ItemCount > -1 Then
            cFeed(i).CreateMenu
           
            If Not cImgMenu.IsWindowVistaOrLater Then
                cImgMenu.RemoveMenuCheckApi cFeed(i).hMenu
            End If
            
            For j = 0 To cFeed(i).ItemCount
                 cImgMenu.PutImageToApiMenu 0, cFeed(i).hMenu, j
            Next
            
            AppendMenu MainMenu, MF_POPUP, cFeed(i).hMenu, CStr(cFeed(i).FeedTitle)
            cImgMenu.PutImageToApiMenu i + 1, MainMenu, i - 1
        End If
    Next
    
    AppendMenu MainMenu, MF_SEPARATOR, 100, ByVal 0&
    AppendMenu MainMenu, MF_STRING, 101, "Configurar"
    AppendMenu MainMenu, MF_SEPARATOR, 100, ByVal 0&
    AppendMenu MainMenu, MF_STRING, 102, "Salir"
    cImgMenu.PutImageToApiMenu 1, MainMenu, cFeed.Count + 1


    If x <> 0 Or y <> 0 Then
        PT.x = x: PT.y = y
    Else
        GetCursorPos PT
    End If

    Load FrmMenuRss
    DoEvents
    PopUpMenu = TrackPopupMenuEx(MainMenu, TPM_RETURNCMD, PT.x, PT.y, hwnd, ByVal 0&)

    DestroyMenu MainMenu

    GetCursorPos PT
    
    If GetAncestor(WindowFromPoint(PT.x, PT.y), GA_ROOT) <> FrmMenuRss.hwnd Then
          Unload FrmMenuRss
    End If

    
End Function

Public Sub Clear()
    Set cFeed = New Collection
End Sub

Public Sub AddFeed(ByVal sURL As String, ByVal lTimeActualize As Long)
    Set cSubMenu = New ClsSubMenu
    
    With cSubMenu
        .UrlFeed = sURL
        .TimeActualize = lTimeActualize
    End With
    
    cFeed.Add cSubMenu
End Sub

Public Sub ActualizeAll()
    On Error Resume Next
    Dim i As Long
    Dim bvData() As Byte
    
    cImgMenu.Clear
    cImgMenu.AddImageFromStream LoadResData("CUSTOM_0", "CUSTOM")
    cImgMenu.AddImageFromStream LoadResData("CUSTOM_2", "CUSTOM")
        
    For i = 1 To cFeed.Count
        DoEvents
        cFeed(i).RefreshFeed
        
        If DownloadImageToStream(GetFaviconFromURL(cFeed(i).UrlFeed), bvData) Then
           Call cImgMenu.AddImageFromStream(bvData)
        Else
            If DownloadImageToStream(GetFaviconFromURL(cFeed(i).FeedLink), bvData) Then
                cImgMenu.AddImageFromStream bvData
            Else
                cImgMenu.AddImageFromStream LoadResData("CUSTOM_1", "CUSTOM")
            End If
        End If
        
    Next
    
    cTimer.DestroyTimer
    cTimer.CreateTimer &HEA60 '1 Minuto
End Sub

Public Sub Init(ByVal hwnd As Long)
    Set cFeed = New Collection
    Set cImgMenu = New clsMenuImage
    Set cTimer = New ClsTimer
    cImgMenu.Init hwnd, 16, 16, True
    
    m_HiLitePos = -1
End Sub

Private Sub Class_Terminate()
    cImgMenu.Clear
    cImgMenu.StopSubclassing
    Set cImgMenu = Nothing
    Set cTimer = Nothing
    Unload FrmMenuRss
End Sub

Private Function LoWord(ByVal Numero As Long) As Long
    LoWord = Numero And &HFFFF&
End Function

Private Function HiWord(ByVal Numero As Long) As Long
    HiWord = Numero \ &H10000 And &HFFFF&
End Function

Private Sub cTimer_Timer(ByVal ThisTime As Long)
    On Error Resume Next
    Dim i As Long
    For i = 1 To cFeed.Count
        If cFeed(i).TimeCount >= cFeed(i).TimeActualize Then
            cFeed(i).TimeCount = 0
            cFeed(i).RefreshFeed
        Else
            cFeed(i).TimeCount = cFeed(i).TimeCount + 1
        End If
    Next
End Sub
